/*
 * Decompiled with CFR 0.152.
 */
package armsimulator;

import armsimulator.BASFS.Error;
import armsimulator.BASFS.Instruction;
import armsimulator.BASFS.Memory;
import armsimulator.BASFS.MyLibrary;
import armsimulator.BASFS.Register;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ARMProgram {
    private Error assembleTimeError = new Error();
    private String filename;
    private ArrayList sourceList;
    public ArrayList commentRemovedSource;
    private ArrayList sourceOfDataSection;
    private ArrayList sourceOfTextSection;
    private ArrayList<Integer> DataSectionLineNo;
    private ArrayList<Integer> TextSectionLineNo;
    private Register Reg;
    private Memory Mem;
    private ArrayList<Instruction> AllInstructions = new ArrayList();

    public ARMProgram(String source) throws IOException {
        this.Reg = new Register();
        this.Mem = new Memory();
        this.readSource(source);
        this.removeComment();
        this.splitDataAndTextSection();
        Error err = this.processDataSection();
        if (!err.isOk()) {
            err.printErrorMsg();
            this.assembleTimeError = err;
            return;
        }
        err = this.processTextSection();
        if (!err.isOk()) {
            err.printErrorMsg();
            this.assembleTimeError = err;
            return;
        }
    }

    public Error getAssembleTimeError() {
        return this.assembleTimeError;
    }

    public void runCurrentInstruction() {
        int startPC;
        ARMProgram aRMProgram = this;
        int currentPC = aRMProgram.Reg.getPC();
        int index = (currentPC - (startPC = Instruction.startAddressOfInst)) / 4;
        if (index < this.AllInstructions.size()) {
            Instruction instr = this.AllInstructions.get(index);
            instr.runSingleInstruction();
        }
    }

    private void RunAllInstructions() throws IOException {
        int PClimit = Register.getPC() + this.AllInstructions.size() * 4;
        int startPC = Register.getPC();
        while (true) {
            ARMProgram aRMProgram = this;
            int currentPC = aRMProgram.Reg.getPC();
            if (currentPC >= PClimit) break;
            int index = (currentPC - startPC) / 4;
            Instruction instr = this.AllInstructions.get(index);
            instr.runSingleInstruction();
        }
        for (int i = 0; i < 10; ++i) {
            int addr = 4 * i + Memory.startAddressOfDynamicData;
            System.out.println(" Fibonacci[" + i + "] = " + Memory.readDynamicMemory(addr));
        }
    }

    public ArrayList<String> getsourceOfTextSection() {
        ArrayList<String> sourceLinesToDisplay = new ArrayList<String>();
        for (int i = 0; i < this.AllInstructions.size(); ++i) {
            sourceLinesToDisplay.add(this.AllInstructions.get(i).getSourceString());
        }
        return sourceLinesToDisplay;
    }

    private void PrintCommentRemovedSource() {
        System.out.println("\n**********  PRINTING COMMENT REMOVED SOURCE FILE  ******************");
        for (int i = 0; i < this.commentRemovedSource.size(); ++i) {
            System.out.println(this.commentRemovedSource.get(i));
        }
    }

    private void PrintSource() {
        System.out.println("**********  PRINTING SOURCE FILE  ******************");
        for (int i = 0; i < this.sourceList.size(); ++i) {
            System.out.println(this.sourceList.get(i));
        }
    }

    public String getSourceLine(int lineNo) {
        if (lineNo >= 1 && lineNo <= this.sourceList.size()) {
            return (String)this.sourceList.get(lineNo - 1);
        }
        return null;
    }

    public void readSource(String source) {
        this.sourceList = new ArrayList();
        String[] tempSource = source.split("\n");
        try {
            for (int i = 0; i < tempSource.length; ++i) {
                this.sourceList.add(tempSource[i]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void removeComment() {
        this.commentRemovedSource = new ArrayList();
        for (int i = 0; i < this.sourceList.size(); ++i) {
            String s = this.removeCommentFromAString((String)this.sourceList.get(i));
            if ((s = MyLibrary.removeBeginningAndEndingSpace(s)).equals("")) continue;
            this.commentRemovedSource.add(s);
        }
    }

    private String removeCommentFromAString(String str) {
        int ind = str.indexOf(64);
        if (ind != -1) {
            str = str.substring(0, ind);
        }
        if ((ind = str.indexOf(59)) != -1) {
            str = str.substring(0, ind);
        }
        return str;
    }

    public void splitDataAndTextSection() {
        this.sourceOfDataSection = new ArrayList();
        this.sourceOfTextSection = new ArrayList();
        this.DataSectionLineNo = new ArrayList();
        this.TextSectionLineNo = new ArrayList();
        boolean DATA = false;
        boolean TEXT = true;
        boolean flag = DATA;
        for (int i = 0; i < this.commentRemovedSource.size(); ++i) {
            String str = (String)this.commentRemovedSource.get(i);
            if ((str = str.toLowerCase()).startsWith(".text")) {
                flag = TEXT;
                continue;
            }
            if (str.startsWith(".data")) {
                flag = DATA;
                continue;
            }
            if (str.startsWith(".arm") || str.startsWith(".global")) continue;
            if (flag == DATA) {
                this.sourceOfDataSection.add(str);
                this.DataSectionLineNo.add(i + 1);
                continue;
            }
            if (str.startsWith(".arm") || str.startsWith(".global")) continue;
            this.sourceOfTextSection.add(str);
            this.TextSectionLineNo.add(i + 1);
        }
    }

    public void printDataAndTextSections() {
        int i;
        System.out.println("\n\nPRINTING DATA SECTION\n\n");
        for (i = 0; i < this.sourceOfDataSection.size(); ++i) {
            System.out.println(this.sourceOfDataSection.get(i));
        }
        System.out.println("\n\nPRINTING TEXT SECTION\n\n");
        for (i = 0; i < this.sourceOfTextSection.size(); ++i) {
            System.out.println(this.sourceOfTextSection.get(i));
        }
    }

    private Error processDataSection() {
        Error err = new Error();
        for (int i = 0; i < this.sourceOfDataSection.size(); ++i) {
            String str = (String)this.sourceOfDataSection.get(i);
            if (this.doesStartWithLabel(str)) {
                String labelName = this.getlabelName(str);
                if (labelName.equals("")) {
                    err = new Error("Invalid Label name, at line " + this.sourceOfDataSection.get(i).toString(), 1);
                    return err;
                }
                Memory.setBeginingAddress(labelName);
                err = this.processDirectives(str.substring(labelName.length() + 1), this.DataSectionLineNo.get(i));
            } else {
                err = this.copyprocessDirectives(str, this.DataSectionLineNo.get(i));
            }
            if (!err.isOk()) break;
        }
        return err;
    }

    private boolean doesStartWithLabel(String str) {
        for (int i = 0; i < str.length(); ++i) {
            if (MyLibrary.isSpaceChar(str.charAt(i))) {
                return false;
            }
            if (str.charAt(i) != ':') continue;
            return true;
        }
        return false;
    }

    private String getlabelName(String str) {
        int ind = -1;
        for (int i = 0; i < str.length() && !MyLibrary.isSpaceChar(str.charAt(i)); ++i) {
            if (str.charAt(i) != ':') continue;
            ind = i;
            break;
        }
        if (ind == -1) {
            return "";
        }
        return str.substring(0, ind);
    }

    private Error copyprocessDirectives(String str, int sourceLineNo) {
        str = MyLibrary.removeBeginningAndEndingSpace(str);
        Error err = new Error();
        if (!str.equals(".arm") && !str.equals(".global")) {
            err = new Error("Invalid directive in line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
            return err;
        }
        return err;
    }

    private Error processDirectives(String str, int sourceLineNo) {
        str = MyLibrary.removeBeginningAndEndingSpace(str);
        Error err = new Error();
        if (str.equals("")) {
            err = new Error("Unknown data type, at line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
            return err;
        }
        if (str.startsWith(".space")) {
            int numBytes;
            str = str.substring(6);
            if (!MyLibrary.isValidNumber(str = MyLibrary.removeBeginningAndEndingSpace(str))) {
                err = new Error("Invalid Numaric Constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                return err;
            }
            try {
                numBytes = MyLibrary.fromStringToInt(str);
            }
            catch (Exception e) {
                err = new Error("Invalid constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                return err;
            }
            if (numBytes > Memory.currentStackAddress - Memory.currentDynamicDataAddress) {
                err = new Error("Segmentation Fault ! Unable To Allocate " + numBytes + " Bytes !", 1);
                return err;
            }
            int numOfWords = numBytes / 4 + (numBytes % 4 == 0 ? 0 : 1);
            for (int i = 0; i < numOfWords; ++i) {
                Memory.addDataInDynamicMemory(0);
            }
        } else {
            if (str.startsWith(".word")) {
                str = str.substring(5);
                if ((str = MyLibrary.removeBeginningAndEndingSpace(str)).indexOf(58) != -1) {
                    int noOfWords;
                    int value;
                    String[] A = str.split("[ ]*:[ ]*");
                    if (A.length < 2) {
                        err = new Error("Syntax Error in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                        return err;
                    }
                    if (!MyLibrary.isValidNumber(A[0])) {
                        err = new Error("Invalid Numaric Constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                        return err;
                    }
                    try {
                        value = MyLibrary.fromStringToInt(A[0]);
                        noOfWords = MyLibrary.fromStringToInt(A[1]);
                    }
                    catch (Exception e) {
                        err = new Error("Invalid constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                        return err;
                    }
                    if (noOfWords * 4 > Memory.currentStackAddress - Memory.currentDynamicDataAddress) {
                        err = new Error("Segmentation Fault ! Unable To Allocate " + noOfWords + " Words !", 1);
                        return err;
                    }
                    for (int i = 0; i < noOfWords; ++i) {
                        Memory.addDataInDynamicMemory(value);
                    }
                } else if (str.indexOf(44) != -1) {
                    String[] A = str.split("[ ]*,[ ]*");
                    int noOfWords = A.length;
                    if (noOfWords * 4 > Memory.currentStackAddress - Memory.currentDynamicDataAddress) {
                        err = new Error("Segmentation Fault ! Unable To Allocate " + noOfWords + " Words !", 1);
                        return err;
                    }
                    for (int i = 0; i < A.length; ++i) {
                        if (!MyLibrary.isValidNumber(A[i])) {
                            err = new Error("Invalid Numaric Constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                            return err;
                        }
                        try {
                            Memory.addDataInDynamicMemory(MyLibrary.fromStringToInt(A[i]));
                            continue;
                        }
                        catch (Exception e) {
                            err = new Error("Invalid constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                            return err;
                        }
                    }
                } else {
                    if (!MyLibrary.isValidNumber(str) && str != "") {
                        err = new Error("Invalid Numaric Constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                        return err;
                    }
                    if (str != "") {
                        try {
                            int res = MyLibrary.fromStringToInt(str);
                            Memory.addDataInDynamicMemory(res);
                        }
                        catch (Exception e) {
                            err = new Error("Invalid constant in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
                            return err;
                        }
                    }
                }
                return err;
            }
            err = new Error("Invalid directive in Line :\n\t" + this.commentRemovedSource.get(sourceLineNo - 1), 1);
            return err;
        }
        return err;
    }

    private Error processTextSection() {
        int startAddress;
        Error err = new Error();
        int currentAddr = startAddress = Instruction.startAddressOfInst;
        for (int i = 0; i < this.sourceOfTextSection.size(); ++i) {
            String str = (String)this.sourceOfTextSection.get(i);
            if ((str = MyLibrary.removeBeginningAndEndingSpace(str)).equals("")) continue;
            if (this.doesStartWithLabel(str)) {
                String labelName = this.getlabelName(str);
                if (labelName.equals("")) {
                    err = new Error("Invalid Label name, at line \n\t" + this.sourceOfTextSection.get(i).toString(), 1);
                    return err;
                }
                Instruction.addressOfLabels.put(labelName, currentAddr);
                str = str.substring(labelName.length() + 1);
                str = MyLibrary.removeBeginningAndEndingSpace(str);
                if (!str.equals("")) {
                    Instruction instr = new Instruction();
                    err = instr.parsInstruction(str, ": \n\t" + this.sourceOfTextSection.get(i).toString());
                    this.AllInstructions.add(instr);
                    currentAddr += 4;
                }
            } else {
                Instruction instr = new Instruction();
                err = instr.parsInstruction(str, ": \n\t" + this.sourceOfTextSection.get(i).toString());
                this.AllInstructions.add(instr);
                currentAddr += 4;
            }
            if (err.isOk()) continue;
            return err;
        }
        err = this.FillAlllabelNamesWithTheirAddress();
        return err;
    }

    private Error FillAlllabelNamesWithTheirAddress() {
        Error err = new Error();
        for (int i = 0; i < this.AllInstructions.size(); ++i) {
            Instruction inst = this.AllInstructions.get(i);
            err = inst.fillLabelNameWithAddress();
            if (!err.isOk()) {
                return err;
            }
            this.AllInstructions.set(i, inst);
        }
        return err;
    }

    private void printAllInstruction() {
        for (int i = 0; i < this.AllInstructions.size(); ++i) {
            Instruction instr = this.AllInstructions.get(i);
            instr.printInstruction();
        }
    }
}

