/*
 * Decompiled with CFR 0.152.
 */
package armsimulator.BASFS;

import armsimulator.BASFS.Error;
import armsimulator.BASFS.Memory;
import armsimulator.BASFS.MyLibrary;
import armsimulator.BASFS.Register;
import java.util.HashMap;

public class Instruction {
    private static int preIndex = 1;
    private static int postIndex = 2;
    private static int preIndexAutoIndexing = 3;
    private static int None = 4;
    private String mnemonic;
    private String cond = "";
    boolean S = false;
    private int[] operands = new int[4];
    private boolean[] isImmediate = new boolean[4];
    private int[] sign = new int[4];
    private int numOperand = 0;
    private String labelName = "";
    private String Shift = "";
    private String sourceString;
    private int Index = 0;
    public static int startAddressOfInst = 0x4000000;
    public static HashMap<String, Integer> addressOfLabels = new HashMap();
    private boolean shifter_carry_out = true;

    public Instruction() {
        for (int i = 0; i < 4; ++i) {
            this.isImmediate[i] = false;
            this.sign[i] = 1;
        }
    }

    public Error parsInstruction(String str, String lineno) {
        Error err = new Error();
        this.sourceString = str;
        str = this.parseMnemonic(err, str);
        err = this.mnemonic.equals("ldr") || this.mnemonic.equals("str") ? this.ParseLoadStoreInstruction(str, lineno) : (this.mnemonic.equals("bl") || this.mnemonic.equals("b") ? this.ParseBranchInstruction(str, lineno) : this.ParseBasicInstruction(str, lineno));
        return err;
    }

    public String getSourceString() {
        return this.sourceString;
    }

    private Error ParseBranchInstruction(String str, String lineno) {
        Error err = new Error();
        if ((str = MyLibrary.removeBeginningAndEndingSpace(str)) == "") {
            err = new Error("Argument missing in branch instruction in line " + lineno, 1);
            return err;
        }
        this.labelName = str;
        return err;
    }

    private Error ParseLoadStoreInstruction(String str, String lineno) {
        int x;
        Error err = new Error();
        int ind = str.indexOf(44);
        if (ind != -1) {
            String Rd = str.substring(0, ind);
            x = Register.getRegisterNumberFromString(Rd = MyLibrary.removeBeginningAndEndingSpace(Rd));
            if (x == -1) {
                err = new Error("Invalid register at line " + lineno, 1);
                return err;
            }
        } else {
            err = new Error("Invalid load instruction in line " + lineno, 1);
            return err;
        }
        this.operands[this.numOperand++] = x;
        str = str.substring(ind + 1);
        str = MyLibrary.removeBeginningAndEndingSpace(str);
        if (str.indexOf(91) == -1) {
            if (str.startsWith("=")) {
                str = str.substring(1);
            }
            if (Memory.localSymbolTable.get(str) == null) {
                err = new Error("Invalid memory address at line " + lineno, 1);
                return err;
            }
            this.operands[this.numOperand] = Memory.localSymbolTable.get(str);
            this.isImmediate[this.numOperand++] = true;
            this.Index = None;
            return err;
        }
        if (str.endsWith("]")) {
            this.Index = preIndex;
            str = str.substring(1, str.length() - 1);
            str = MyLibrary.removeBeginningAndEndingSpace(str);
            err = this.parseOperandsLS(str, "preIndex", lineno);
        } else if (str.endsWith("]!")) {
            this.Index = preIndexAutoIndexing;
            str = str.substring(1, str.length() - 2);
            str = MyLibrary.removeBeginningAndEndingSpace(str);
            err = this.parseOperandsLS(str, "preAuto", lineno);
        } else {
            this.Index = postIndex;
            int indexOfFirstComma = str.indexOf(44);
            String Rn = str.substring(0, indexOfFirstComma);
            Rn = MyLibrary.removeBeginningAndEndingSpace(Rn);
            err = this.fillOperand(Rn = Rn.substring(1, Rn.length() - 1), lineno);
            if (!err.isOk()) {
                return err;
            }
            str = str.substring(indexOfFirstComma + 1);
            err = this.parseOperandsLS(str, "post", lineno);
        }
        return err;
    }

    private Error parseOperandsLS(String str, String index, String lineno) {
        Error err = new Error();
        String[] A = str.split(",");
        if (index == "post" && A.length != 1) {
            err = new Error("Too many arguments in load/store instruction at line " + lineno, 1);
            return err;
        }
        if ((index == "preindex" || index == "preAuto") && A.length > 2) {
            err = new Error("Too many arguments in load/store instruction at line " + lineno, 1);
            return err;
        }
        for (int i = 0; i < A.length; ++i) {
            String temp = A[i];
            temp = MyLibrary.removeBeginningAndEndingSpace(temp);
            err = i == A.length - 1 && this.isShiftOperation(temp) ? new Error("Shift Operations not permitted in load/store. at Line: " + lineno, 1) : this.fillOperand(temp, lineno);
        }
        return err;
    }

    private boolean isRegister(String str) {
        int x;
        String temp = str;
        if (temp.startsWith("+") || temp.startsWith("-")) {
            temp = temp.substring(1);
        }
        return (x = Register.getRegisterNumberFromString(temp)) != -1;
    }

    private Error parseOperands(String str, String lineno, int noOfArgs) {
        Error err = new Error();
        String[] A = str.split(",");
        if (A.length < noOfArgs) {
            err = new Error("Too few arguments at line " + lineno, 1);
            return err;
        }
        if (A.length > noOfArgs + 1) {
            err = new Error("Too many arguments at line " + lineno, 1);
            return err;
        }
        if (A.length == noOfArgs + 1 && !this.isShiftOperation(A[A.length - 1])) {
            err = new Error("Too many arguments at line" + lineno, 1);
            return err;
        }
        boolean shiftop = false;
        boolean gonein = false;
        if (A.length == 4 && noOfArgs == 3) {
            shiftop = true;
            gonein = false;
        }
        for (int i = 0; i < A.length; ++i) {
            String temp = A[i];
            temp = MyLibrary.removeBeginningAndEndingSpace(temp);
            if (i < noOfArgs - 1 && !this.isRegister(temp)) {
                err = new Error("Operand " + i + " should be a register. Line " + lineno, 1);
                return err;
            }
            if (i == A.length - 1 && this.isShiftOperation(temp)) {
                err = this.fillShiftOperationInfo(temp, lineno);
                gonein = true;
                continue;
            }
            err = this.fillOperand(temp, lineno);
        }
        return err;
    }

    private Error fillShiftOperationInfo(String str, String lineno) {
        Error err = new Error();
        if ((str = MyLibrary.removeBeginningAndEndingSpace(str)).startsWith("lsl")) {
            this.Shift = "lsl";
        } else if (str.startsWith("lsr")) {
            this.Shift = "lsr";
        } else if (str.startsWith("asl")) {
            this.Shift = "asl";
        } else if (str.startsWith("asr")) {
            this.Shift = "asr";
        } else {
            err = new Error("Invalid shift operation at line " + lineno, 1);
            return err;
        }
        str = str.substring(3);
        err = this.fillOperand(str, lineno);
        return err;
    }

    private boolean isShiftOperation(String str) {
        return str.contains("lsl") || str.contains("lsr") || str.contains("asl") || str.contains("asr") || str.contains("ror") || str.contains("rrx");
    }

    private Error fillOperand(String str, String lineno) {
        str = MyLibrary.removeBeginningAndEndingSpace(str);
        Error err = new Error();
        if (str.equals("")) {
            err = new Error("Invalid operand. in Line " + lineno, 1);
            return err;
        }
        this.sign[this.numOperand] = 1;
        if (this.isImmediateValue(str)) {
            this.isImmediate[this.numOperand] = true;
            str = str.substring(1);
            if ((str = MyLibrary.removeBeginningAndEndingSpace(str)).startsWith("+")) {
                str = str.substring(1);
                str = MyLibrary.removeBeginningAndEndingSpace(str);
            } else if (str.startsWith("-")) {
                this.sign[this.numOperand] = -1;
                str = str.substring(1);
                str = MyLibrary.removeBeginningAndEndingSpace(str);
            }
            try {
                this.operands[this.numOperand++] = MyLibrary.fromStringToInt(str);
            }
            catch (Exception e) {
                err = new Error("Invalid immediate constant at line " + lineno, 1);
                return err;
            }
        } else {
            if (str.startsWith("+")) {
                str = str.substring(1);
                str = MyLibrary.removeBeginningAndEndingSpace(str);
            } else if (str.startsWith("-")) {
                this.sign[this.numOperand] = -1;
                str = str.substring(1);
                str = MyLibrary.removeBeginningAndEndingSpace(str);
            }
            int x = Register.getRegisterNumberFromString(str);
            if (x == -1) {
                err = new Error("Invalid Operand! Line " + lineno, 1);
                return err;
            }
            this.operands[this.numOperand++] = x;
        }
        return err;
    }

    private boolean isImmediateValue(String str) {
        return str.startsWith("#");
    }

    boolean istwoarg(String str) {
        return (str = str.toLowerCase()).equals("mov") || str.equals("clz") || str.equals("tst") || str.equals("teq") || str.equals("cmp") || str.equals("cmn") || str.equals("swp");
    }

    private Error ParseBasicInstruction(String str, String lineno) {
        Error err = new Error();
        if (this.mnemonic.equals("invalid")) {
            err = new Error("Invalid instruction at line " + lineno, 1);
            return err;
        }
        String[] A = str.split(",");
        int noOfargs = 3;
        if (this.istwoarg(this.mnemonic)) {
            noOfargs = 2;
        }
        if (this.mnemonic.equals("mla")) {
            noOfargs = 4;
        }
        err = this.parseOperands(str, lineno, noOfargs);
        return err;
    }

    String parseMnemonic(Error err, String str) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < str.length() && !Character.isSpace(str.charAt(i)); ++i) {
            sb.append(str.charAt(i));
        }
        String temp = sb.toString();
        str = str.substring(temp.length());
        str = MyLibrary.removeBeginningAndEndingSpace(str);
        if (temp.startsWith("adc")) {
            this.mnemonic = "adc";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("add")) {
            this.mnemonic = "add";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("and")) {
            this.mnemonic = "and";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("bic")) {
            this.mnemonic = "bic";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("clz")) {
            this.mnemonic = "clz";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("cmn")) {
            this.mnemonic = "cmn";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("cmp")) {
            this.mnemonic = "cmp";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("eor")) {
            this.mnemonic = "eor";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("ldr")) {
            this.mnemonic = "ldr";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("mla")) {
            this.mnemonic = "mla";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("mov")) {
            this.mnemonic = "mov";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("mul")) {
            this.mnemonic = "mul";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("mvn")) {
            this.mnemonic = "mvn";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("orr")) {
            this.mnemonic = "orr";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("rsb")) {
            this.mnemonic = "rsb";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("rsc")) {
            this.mnemonic = "rsc";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("sbc")) {
            this.mnemonic = "sbc";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("str")) {
            this.mnemonic = "str";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("sub")) {
            this.mnemonic = "sub";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("swp")) {
            this.mnemonic = "swp";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("teq")) {
            this.mnemonic = "teq";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("tst")) {
            this.mnemonic = "tst";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("ble") || temp.startsWith("blt")) {
            this.mnemonic = "b";
            temp = temp.substring(1);
            this.setCondAndS(temp);
        } else if (temp.startsWith("bl")) {
            this.mnemonic = "bl";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else if (temp.startsWith("b")) {
            this.mnemonic = "b";
            temp = temp.substring(this.mnemonic.length());
            this.setCondAndS(temp);
        } else {
            this.mnemonic = "invalid";
            err = new Error("instruction not supported in this version", 1);
        }
        return str;
    }

    private void setCondAndS(String str) {
        if (str.equals("")) {
            return;
        }
        if (str.equals("eq")) {
            this.cond = "eq";
            str = str.substring(2);
        } else if (str.equals("ne")) {
            this.cond = "ne";
            str = str.substring(2);
        } else if (str.equals("cs")) {
            this.cond = "cs";
            str = str.substring(2);
        } else if (str.equals("hs")) {
            this.cond = "hs";
            str = str.substring(2);
        } else if (str.equals("cc")) {
            this.cond = "cc";
            str = str.substring(2);
        } else if (str.equals("lo")) {
            this.cond = "lo";
            str = str.substring(2);
        } else if (str.equals("mi")) {
            this.cond = "mi";
            str = str.substring(2);
        } else if (str.equals("pl")) {
            this.cond = "pl";
            str = str.substring(2);
        } else if (str.equals("vs")) {
            this.cond = "vs";
            str = str.substring(2);
        } else if (str.equals("vc")) {
            this.cond = "vc";
            str = str.substring(2);
        } else if (str.equals("hi")) {
            this.cond = "hi";
            str = str.substring(2);
        } else if (str.equals("ls")) {
            this.cond = "ls";
            str = str.substring(2);
        } else if (str.equals("ge")) {
            this.cond = "ge";
            str = str.substring(2);
        } else if (str.equals("lt")) {
            this.cond = "lt";
            str = str.substring(2);
        } else if (str.equals("gt")) {
            this.cond = "gt";
            str = str.substring(2);
        } else if (str.equals("le")) {
            this.cond = "le";
            str = str.substring(2);
        } else if (str.equals("al")) {
            this.cond = "al";
            str = str.substring(2);
        }
        if (str.equals("s")) {
            this.S = true;
        }
    }

    public Error fillLabelNameWithAddress() {
        Error err = new Error();
        if (this.labelName.equals("")) {
            return err;
        }
        this.isImmediate[this.numOperand] = true;
        if (addressOfLabels.get(this.labelName) == null) {
            err = new Error("Invalid Label -> " + this.labelName, 1);
        } else {
            this.operands[this.numOperand++] = addressOfLabels.get(this.labelName);
        }
        return err;
    }

    public void printInstruction() {
        System.out.println("\nmnemonic: " + this.mnemonic + "<" + this.cond + ">" + "<" + (this.S ? "s" : "") + ">");
        for (int i = 0; i < this.numOperand; ++i) {
            System.out.println("operand[" + i + "]=" + this.operands[i] + "  sign[" + i + "]=" + this.sign[i] + " isImmediate[" + i + "]=" + this.isImmediate[i]);
        }
        System.out.println("label : " + this.labelName);
        System.out.println("Shift : " + this.Shift);
        System.out.println("Index : " + this.Index);
        System.out.println("");
    }

    private int getShifterOperand(int ind) {
        int ret = this.getOperand(ind);
        this.shifter_carry_out = Register.isCSet();
        if (!this.Shift.equals("") && ind < this.numOperand - 1) {
            int sft = this.getOperand(ind + 1);
            if (this.Shift.equals("lsl") || this.Shift.equals("asl")) {
                int Rm = ret;
                ret <<= sft;
                this.shifter_carry_out = this.isImmediate[ind + 1] ? (sft == 0 ? Register.isCSet() : Register.isSet(Rm, 32 - sft)) : (sft == 0 ? Register.isCSet() : (sft < 32 ? Register.isSet(Rm, 32 - sft) : (sft == 32 ? Register.isSet(Rm, 0) : false)));
            } else if (this.Shift.equals("lsr")) {
                int Rm = ret;
                ret >>>= sft;
                this.shifter_carry_out = this.isImmediate[ind + 1] ? (sft == 0 ? Register.isSet(Rm, 31) : Register.isSet(Rm, sft - 1)) : (sft == 0 ? Register.isCSet() : (sft < 32 ? Register.isSet(Rm, sft - 1) : (sft == 32 ? Register.isSet(Rm, 31) : false)));
            } else if (this.Shift.equals("asr")) {
                int Rm = ret;
                ret >>= sft;
                this.shifter_carry_out = this.isImmediate[ind + 1] ? (sft == 0 ? Register.isSet(Rm, 31) : Register.isSet(Rm, sft - 1)) : (sft == 0 ? Register.isCSet() : (sft < 32 ? Register.isSet(Rm, sft - 1) : Register.isSet(Rm, 31)));
            }
        }
        return ret;
    }

    private int getOperand(int ind) {
        int ret = this.isImmediate[ind] ? this.operands[ind] : Register.getReg(this.operands[ind]);
        return ret * this.sign[ind];
    }

    static int count_leading_zeros(int src) {
        for (int i = 31; i >= 0; --i) {
            if ((src & 1 << i) == 0) continue;
            return 31 - i;
        }
        return 32;
    }

    boolean conditioncheck() {
        if (this.cond.equals("")) {
            return true;
        }
        return Register.ConditionPassed(this.cond);
    }

    public void runSingleInstruction() {
        if (!this.conditioncheck()) {
            Register.incrementPCToNextInstruction();
            return;
        }
        if (this.mnemonic.equals("adc")) {
            int add1 = this.getOperand(1) + (Register.isCSet() ? 1 : 0);
            int add2 = this.getShifterOperand(2);
            int sum = add1 + add2;
            Register.updateRegister(this.operands[0], sum);
            if (this.S) {
                this.updateNFlag(sum);
                this.updateZFlag(sum);
                if (add1 >= 0 && add2 >= 0 && sum < 0 || add1 < 0 && add2 < 0 && sum >= 0) {
                    Register.setC();
                    Register.setV();
                } else {
                    Register.clearC();
                    Register.clearV();
                }
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("add")) {
            int add1 = this.getOperand(1);
            int add2 = this.getShifterOperand(2);
            int sum = add1 + add2;
            Register.updateRegister(this.operands[0], sum);
            if (this.S) {
                this.updateNFlag(sum);
                this.updateZFlag(sum);
                if (add1 >= 0 && add2 >= 0 && sum < 0 || add1 < 0 && add2 < 0 && sum >= 0) {
                    Register.setC();
                    Register.setV();
                } else {
                    Register.clearC();
                    Register.clearV();
                }
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("and")) {
            int o1 = this.getOperand(1);
            int o2 = this.getShifterOperand(2);
            int res = o1 & o2;
            Register.updateRegister(this.operands[0], res);
            if (this.S) {
                this.updateNFlag(res);
                this.updateZFlag(res);
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("bic")) {
            int o1 = this.getOperand(1);
            int o2 = this.getShifterOperand(2);
            int res = o1 & ~o2;
            Register.updateRegister(this.operands[0], res);
            if (this.S) {
                this.updateNFlag(res);
                this.updateZFlag(res);
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("clz")) {
            int o1 = this.getOperand(1);
            int res = Instruction.count_leading_zeros(o1);
            Register.updateRegister(this.operands[0], res);
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("cmn")) {
            int add1 = this.getOperand(0);
            int add2 = this.getShifterOperand(1);
            int alu_out = add1 + add2;
            this.updateNFlag(alu_out);
            this.updateZFlag(alu_out);
            if (add1 >= 0 && add2 >= 0 && alu_out < 0 || add1 < 0 && add2 < 0 && alu_out >= 0) {
                Register.setC();
                Register.setV();
            } else {
                Register.clearC();
                Register.clearV();
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("cmp")) {
            boolean cflag;
            int o1 = this.getOperand(0);
            int o2 = this.getShifterOperand(1);
            int alu_out = o1 - o2;
            this.updateNFlag(alu_out);
            this.updateZFlag(alu_out);
            boolean bl = cflag = !this.BorrowFrom(o1, o2);
            if (cflag) {
                Register.setC();
            } else {
                Register.clearC();
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("eor")) {
            int o1 = this.getOperand(1);
            int o2 = this.getShifterOperand(2);
            int res = o1 ^ o2;
            Register.updateRegister(this.operands[0], res);
            if (this.S) {
                this.updateNFlag(res);
                this.updateZFlag(res);
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("ldr")) {
            if (this.Index == preIndex) {
                int addr = this.getOperand(1);
                if (this.numOperand > 2) {
                    addr += this.getShifterOperand(2);
                }
                Register.updateRegister(this.operands[0], Memory.readDynamicMemory(addr));
            } else if (this.Index == preIndexAutoIndexing) {
                int addr = this.getOperand(1);
                if (this.numOperand > 2) {
                    addr += this.getShifterOperand(2);
                }
                Register.updateRegister(this.operands[0], Memory.readDynamicMemory(addr));
                Register.updateRegister(this.operands[1], addr);
            } else if (this.Index == postIndex) {
                Register.updateRegister(this.operands[0], Memory.readDynamicMemory(this.getOperand(1)));
                if (this.numOperand > 2) {
                    Register.updateRegister(this.operands[1], this.getOperand(1) + this.getShifterOperand(2));
                }
            } else {
                Register.updateRegister(this.operands[0], this.getOperand(1));
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("mov")) {
            Register.updateRegister(this.operands[0], this.getShifterOperand(1));
            if (this.S) {
                int value = Register.getReg(this.operands[0]);
                this.updateNFlag(value);
                this.updateZFlag(value);
                this.updateCFlag(this.shifter_carry_out);
            }
            if (this.operands[0] != 15) {
                Register.incrementPCToNextInstruction();
            }
        } else if (this.mnemonic.equals("mul")) {
            int op1 = this.getOperand(1);
            int op2 = this.getShifterOperand(2);
            long product = op1 * op2;
            int Rd_value = (int)(product << 32 >> 32);
            Register.updateRegister(this.operands[0], Rd_value);
            if (this.S) {
                this.updateNFlag(Rd_value);
                this.updateZFlag(Rd_value);
            }
            Register.incrementPCToNextInstruction();
        } else if (this.mnemonic.equals("mla")) {
            int op1 = this.getOperand(1);
            int op2 = this.getOperand(2);
            int op3 = this.getShifterOperand(3);
            int res = op1 * op2 + op3;
            Register.updateRegister(this.operands[0], res);
            Register.incrementPCToNextInstruction();
        } else if (!this.mnemonic.equals("mvn")) {
            if (this.mnemonic.equals("orr")) {
                int o1 = this.getOperand(1);
                int o2 = this.getShifterOperand(2);
                int res = o1 | o2;
                Register.updateRegister(this.operands[0], res);
                if (this.S) {
                    this.updateNFlag(res);
                    this.updateZFlag(res);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("rsb")) {
                int sub1 = this.getOperand(1);
                int sub2 = this.getShifterOperand(2);
                int sub = sub2 - sub1;
                Register.updateRegister(this.operands[0], sub);
                if (this.S) {
                    this.updateNFlag(sub);
                    this.updateZFlag(sub);
                    boolean cflag = !this.BorrowFrom(sub2, sub1);
                    this.updateCFlag(cflag);
                    boolean vflag = this.OverFlowFromSub(sub2, sub1);
                    this.updateVFlag(vflag);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("rsc")) {
                int sub1 = this.getOperand(1);
                int sub2 = this.getShifterOperand(2) - (Register.isCSet() ? 0 : 1);
                int sub = sub2 - sub1;
                Register.updateRegister(this.operands[0], sub);
                if (this.S) {
                    this.updateNFlag(sub);
                    this.updateZFlag(sub);
                    boolean cflag = !this.BorrowFrom(sub2, sub1);
                    this.updateCFlag(cflag);
                    boolean vflag = this.OverFlowFromSub(sub2, sub1);
                    this.updateVFlag(vflag);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("sbc")) {
                int sub1 = this.getOperand(1) - (Register.isCSet() ? 0 : 1);
                int sub2 = this.getShifterOperand(2);
                int sub = sub1 - sub2;
                Register.updateRegister(this.operands[0], sub);
                if (this.S) {
                    this.updateNFlag(sub);
                    this.updateZFlag(sub);
                    boolean cflag = !this.BorrowFrom(sub1, sub2);
                    this.updateCFlag(cflag);
                    boolean vflag = this.OverFlowFromSub(sub1, sub2);
                    this.updateVFlag(vflag);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("str")) {
                if (this.Index == preIndex) {
                    int addr = this.getOperand(1);
                    if (this.numOperand > 2) {
                        addr += this.getShifterOperand(2);
                    }
                    Memory.updateDynamicMemory(addr, this.getOperand(0));
                } else if (this.Index == preIndexAutoIndexing) {
                    int addr = this.getOperand(1);
                    if (this.numOperand > 2) {
                        addr += this.getShifterOperand(2);
                    }
                    Memory.updateDynamicMemory(addr, this.getOperand(0));
                    Register.updateRegister(this.operands[1], addr);
                } else if (this.Index == postIndex) {
                    Memory.updateDynamicMemory(this.getOperand(1), this.getOperand(0));
                    if (this.numOperand > 2) {
                        Register.updateRegister(this.operands[1], this.getOperand(1) + this.getShifterOperand(2));
                    }
                } else {
                    Memory.updateDynamicMemory(this.getOperand(1), this.getOperand(0));
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("sub")) {
                int sub1 = this.getOperand(1);
                int sub2 = this.getShifterOperand(2);
                int sub = sub1 - sub2;
                Register.updateRegister(this.operands[0], sub);
                if (this.S) {
                    this.updateNFlag(sub);
                    this.updateZFlag(sub);
                    boolean cflag = !this.BorrowFrom(sub1, sub2);
                    this.updateCFlag(cflag);
                    boolean vflag = this.OverFlowFromSub(sub1, sub2);
                    this.updateVFlag(vflag);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("swp")) {
                int x = this.getOperand(0);
                Register.updateRegister(this.operands[0], this.getShifterOperand(1));
                Register.updateRegister(this.operands[1], x);
                if (this.S) {
                    int value = Register.getReg(this.operands[0]);
                    this.updateNFlag(value);
                    this.updateZFlag(value);
                    this.updateCFlag(this.shifter_carry_out);
                }
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("teq")) {
                int o1 = this.getOperand(0);
                int o2 = this.getShifterOperand(1);
                int res = o1 ^ o2;
                this.updateNFlag(res);
                this.updateZFlag(res);
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("tst")) {
                int o1 = this.getOperand(0);
                int o2 = this.getShifterOperand(1);
                int res = o1 & o2;
                this.updateNFlag(res);
                this.updateZFlag(res);
                Register.incrementPCToNextInstruction();
            } else if (this.mnemonic.equals("bl")) {
                Register.updateRegister("lr", Register.getPC() + 4);
                Register.updatePCAbsolute(this.getOperand(0));
            } else if (this.mnemonic.equals("b")) {
                Register.updatePCAbsolute(this.getOperand(0));
            }
        }
    }

    private void updateCFlag(boolean cflag) {
        if (cflag) {
            Register.setC();
        } else {
            Register.clearC();
        }
    }

    private void updateVFlag(boolean vflag) {
        if (vflag) {
            Register.setV();
        } else {
            Register.clearV();
        }
    }

    private boolean BorrowFrom(int a, int b) {
        long A = (long)a & 0xFFFFFFFFL;
        long B = (long)b & 0xFFFFFFFFL;
        return A < B;
    }

    private boolean OverFlowFromSub(int sub1, int sub2) {
        int dif = sub1 - sub2;
        return sub1 >= 0 && sub2 < 0 && dif < 0 || sub1 < 0 && sub2 >= 0 && dif >= 0;
    }

    private void updateZFlag(int val) {
        if (val == 0) {
            Register.setZ();
        } else {
            Register.clearZ();
        }
    }

    private void updateNFlag(int val) {
        if (val < 0) {
            Register.setN();
        } else {
            Register.clearN();
        }
    }
}

