/*
 * Decompiled with CFR 0.152.
 */
package armsimulator.BASFS;

import armsimulator.BASFS.Register;
import java.util.ArrayList;
import java.util.HashMap;

public class Memory {
    public static int startAddressOfStack;
    public static int currentStackAddress;
    public static ArrayList<Integer> dynamicData;
    public static int startAddressOfDynamicData;
    public static int currentDynamicDataAddress;
    public static HashMap<String, Integer> localSymbolTable;

    public Memory() {
        currentStackAddress = startAddressOfStack = Register.getReg("sp");
        dynamicData = new ArrayList();
        currentDynamicDataAddress = startAddressOfDynamicData = 0x10000000;
    }

    public static void setBeginingAddress(String VariableName) {
        localSymbolTable.put(VariableName, currentDynamicDataAddress);
    }

    public static void addDataInDynamicMemory(int value) {
        dynamicData.add(value);
        currentDynamicDataAddress += 4;
    }

    public static int readDynamicMemory(int address) {
        if (address < startAddressOfDynamicData) {
            return 0;
        }
        int index = (address - startAddressOfDynamicData) / 4;
        int len = dynamicData.size();
        if (index >= len) {
            return 0;
        }
        return dynamicData.get(index);
    }

    public static int readWord(int addr) {
        return Memory.readDynamicMemory(addr);
    }

    public static int readDynamicMemory(String VariableName, int disp) {
        int startAddress = localSymbolTable.get(VariableName);
        int address = startAddress + disp;
        return Memory.readDynamicMemory(address);
    }

    public static int readDynamicMemory(String VariableName) {
        return Memory.readDynamicMemory(VariableName, 0);
    }

    public static void storeWord(int address, int value) {
        Memory.updateDynamicMemory(address, value);
    }

    public static void updateDynamicMemory(int address, int value) {
        if (address < startAddressOfDynamicData) {
            return;
        }
        int index = (address - startAddressOfDynamicData) / 4;
        for (int len = dynamicData.size(); index >= len; ++len) {
            dynamicData.add(0);
        }
        dynamicData.set(index, value);
    }

    public static void updateDynamicMemory(String VariableName, int disp, int value) {
        int startAddress = localSymbolTable.get(VariableName);
        int address = startAddress + disp;
        Memory.updateDynamicMemory(address, value);
    }

    public static void updateDynamicMemory(String VariableName, int value) {
        Memory.updateDynamicMemory(VariableName, 0, value);
    }

    public String fromDecToHex(int val) {
        String ret = "0x";
        int Mask = 15;
        for (int i = 0; i < 8; ++i) {
            int v = Mask & val >> 4 * (7 - i);
            ret = ret + this.HexStringOfDecValue(v);
        }
        return ret;
    }

    private String HexStringOfDecValue(int v) {
        char ch = (char)(v < 10 ? v + 48 : v - 10 + 65);
        return Character.toString(ch);
    }

    public int fromHexToDec(String str) {
        int sign = 1;
        if (str.charAt(0) == '-') {
            sign = -1;
            str = str.substring(3);
        } else {
            str = str.substring(2);
        }
        return sign * Integer.parseInt(str, 16);
    }

    private int decValueOfHexChar(char ch) {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        return ch - 65 + 10;
    }

    public static void printDynamicMemory() {
        for (int i = 0; i < dynamicData.size(); ++i) {
            System.out.println(Integer.toString(startAddressOfDynamicData + 4 * i) + " " + Integer.toString(dynamicData.get(i)));
        }
    }

    static {
        localSymbolTable = new HashMap();
    }
}

