/*
 * Decompiled with CFR 0.152.
 */
package armsimulator.BASFS;

public class Register {
    private static int[] Reg = new int[16];
    private static int CPSR;

    public Register() {
        for (int i = 0; i < Reg.length; ++i) {
            Register.Reg[i] = 0;
        }
        this.initializePC();
        this.initializeSP();
        this.initializeCPSR();
    }

    public Register(int startAddrOfPC, int startAddrOfStack) {
        for (int i = 0; i < Reg.length; ++i) {
            Register.Reg[i] = 0;
        }
        this.initializeCPSR();
        this.initializePC(startAddrOfPC);
        this.initializeSP(startAddrOfStack);
    }

    private void initializeCPSR() {
    }

    private void initializePC() {
        Register.updatePCAbsolute(0x4000000);
    }

    private void initializeSP() {
        Register.updateRegister("sp", 0x10100000);
    }

    private void initializePC(int startAddrOfPC) {
        Register.updatePCAbsolute(startAddrOfPC);
    }

    private void initializeSP(int startAddrOfStack) {
        Register.updateRegister("sp", startAddrOfStack);
    }

    public static int getPC() {
        return Reg[15];
    }

    public static void updatePCAbsolute(int targetAddress) {
        Register.Reg[15] = targetAddress;
    }

    public static void updatePCRelative(int relativeShift) {
        Register.updatePCAbsolute(Register.getPC() + relativeShift);
    }

    public static void incrementPCToNextInstruction() {
        Register.updatePCAbsolute(Register.getPC() + 4);
    }

    public static int getRegValue(int regNo) {
        if (regNo >= 0 && regNo < Reg.length) {
            return Reg[regNo];
        }
        return -1;
    }

    public static void setRegValue(int regNo, int value) {
        if (regNo >= 0 && regNo < Reg.length) {
            Register.Reg[regNo] = value;
        }
    }

    public static void updateRegister(int regNo, int newValue) {
        if (regNo >= 0 && regNo < Reg.length) {
            Register.Reg[regNo] = newValue;
        }
    }

    public static void updateRegister(String regStr, int newValue) {
        int regNo = Register.getRegisterNumberFromString(regStr);
        Register.updateRegister(regNo, newValue);
    }

    public static int getReg(int regNo) {
        if (regNo >= 0 && regNo < Reg.length) {
            return Reg[regNo];
        }
        return 0;
    }

    public static int getReg(String regName) {
        int regNo = Register.getRegisterNumberFromString(regName);
        return Register.getReg(regNo);
    }

    public static boolean isSet(int no, int n) {
        if (n >= 0 && n < 32) {
            return (no & 1 << n) != 0;
        }
        return false;
    }

    public static boolean isClear(int no, int n) {
        if (n >= 0 && n < 32) {
            return !Register.isSet(no, n);
        }
        return false;
    }

    public static boolean isNSet() {
        return Register.isSet(CPSR, 31);
    }

    public static boolean isNClear() {
        return Register.isClear(CPSR, 31);
    }

    public static boolean isZSet() {
        return Register.isSet(CPSR, 30);
    }

    public static boolean isZClear() {
        return Register.isClear(CPSR, 30);
    }

    public static boolean isCSet() {
        return Register.isSet(CPSR, 29);
    }

    public static boolean isCClear() {
        return Register.isClear(CPSR, 29);
    }

    public static boolean isVSet() {
        return Register.isSet(CPSR, 28);
    }

    public static boolean isVClear() {
        return Register.isClear(CPSR, 28);
    }

    private static int set(int no, int n) {
        if (n >= 0 && n < 32) {
            no |= 1 << n;
        }
        return no;
    }

    private static int clear(int no, int n) {
        if (n >= 0 && n < 32 && Register.isSet(no, n)) {
            no -= 1 << n;
        }
        return no;
    }

    public static void setN() {
        CPSR = Register.set(CPSR, 31);
    }

    public static void clearN() {
        CPSR = Register.clear(CPSR, 31);
    }

    public static void setZ() {
        CPSR = Register.set(CPSR, 30);
    }

    public static void clearZ() {
        CPSR = Register.clear(CPSR, 30);
    }

    public static void setC() {
        CPSR = Register.set(CPSR, 29);
    }

    public static void clearC() {
        CPSR = Register.clear(CPSR, 29);
    }

    public static void setV() {
        CPSR = Register.set(CPSR, 28);
    }

    public static void clearV() {
        CPSR = Register.clear(CPSR, 28);
    }

    public static boolean isEQ() {
        return Register.isZSet();
    }

    public static boolean isNE() {
        return Register.isZClear();
    }

    public static boolean isCS() {
        return Register.isCSet();
    }

    public static boolean isHS() {
        return Register.isCSet();
    }

    public static boolean isCC() {
        return Register.isCClear();
    }

    public static boolean isLO() {
        return Register.isCClear();
    }

    public static boolean isMI() {
        return Register.isNSet();
    }

    public static boolean isPL() {
        return Register.isNClear();
    }

    public static boolean isVS() {
        return Register.isVSet();
    }

    public static boolean isVC() {
        return Register.isVClear();
    }

    public static boolean isHI() {
        return Register.isCSet() && Register.isZClear();
    }

    public static boolean isLS() {
        return Register.isCClear() || Register.isZSet();
    }

    public static boolean isGE() {
        return Register.isNSet() && Register.isVSet() || Register.isNClear() && Register.isVClear();
    }

    public static boolean isLT() {
        return Register.isNSet() && Register.isVClear() || Register.isNClear() && Register.isVSet();
    }

    public static boolean isGT() {
        return Register.isZClear() && Register.isGE();
    }

    public static boolean isLE() {
        return Register.isZSet() || Register.isLT();
    }

    public static boolean isAL() {
        return true;
    }

    public static int getRegisterNumberFromString(String str) {
        if ((str = str.toLowerCase()).equals("r0")) {
            return 0;
        }
        if (str.equals("r1")) {
            return 1;
        }
        if (str.equals("r2")) {
            return 2;
        }
        if (str.equals("r3")) {
            return 3;
        }
        if (str.equals("r4")) {
            return 4;
        }
        if (str.equals("r5")) {
            return 5;
        }
        if (str.equals("r6")) {
            return 6;
        }
        if (str.equals("r7")) {
            return 7;
        }
        if (str.equals("r8")) {
            return 8;
        }
        if (str.equals("r9")) {
            return 9;
        }
        if (str.equals("r10")) {
            return 10;
        }
        if (str.equals("r11")) {
            return 11;
        }
        if (str.equals("r12")) {
            return 12;
        }
        if (str.equals("r13") || str.equals("sp")) {
            return 13;
        }
        if (str.equals("r14") || str.equals("lr")) {
            return 14;
        }
        if (str.equals("r15") || str.equals("pc")) {
            return 15;
        }
        if (str.equals("r16")) {
            return 16;
        }
        return -1;
    }

    public static void printAllReg() {
        System.out.println("\nPRINTING ALL REGISTERS");
        for (int i = 0; i < Reg.length; ++i) {
            System.out.println(i + " " + Reg[i]);
        }
    }

    public static boolean ConditionPassed(String cond) {
        if (cond.equals("eq")) {
            return Register.isEQ();
        }
        if (cond.equals("ne")) {
            return Register.isNE();
        }
        if (cond.equals("cs")) {
            return Register.isCS();
        }
        if (cond.equals("hs")) {
            return Register.isHS();
        }
        if (cond.equals("cc")) {
            return Register.isCC();
        }
        if (cond.equals("lo")) {
            return Register.isLO();
        }
        if (cond.equals("mi")) {
            return Register.isMI();
        }
        if (cond.equals("pl")) {
            return Register.isPL();
        }
        if (cond.equals("vs")) {
            return Register.isVS();
        }
        if (cond.equals("vc")) {
            return Register.isVC();
        }
        if (cond.equals("hi")) {
            return Register.isHI();
        }
        if (cond.equals("ls")) {
            return Register.isLS();
        }
        if (cond.equals("ge")) {
            return Register.isGE();
        }
        if (cond.equals("lt")) {
            return Register.isLT();
        }
        if (cond.equals("gt")) {
            return Register.isGT();
        }
        if (cond.equals("le")) {
            return Register.isLE();
        }
        return cond.equals("al");
    }
}

